local menuState = {
	MainChoice = 1,		-- choice on the main menu
	CurState = nil,		-- menu states (see mainChoices below)
	CurChoice = nil,	-- choice within a submenu

	JudgeStyle = nil,	-- index for judge style
	JudgeTicks = nil,	-- index for judge ticks
}

local mainChoices = { "JudgmentStyle", "JudgmentTicks" }

local JudgmentChoices = { "Normal", "sm-ssc", "Classic", "Groovy" }

local optionState = {
	JudgmentStyle = nil,
	JudgmentTicks = nil,
}
if ThemePrefs.Get("JudgeStyle") then
	optionState.JudgmentStyle = ThemePrefs.Get("JudgeStyle")
else
	optionState.JudgmentStyle = "Normal"
end
if ThemePrefs.Get("JudgeTicks") ~= nil then
	optionState.JudgmentTicks = ThemePrefs.Get("JudgeTicks")
else
	optionState.JudgmentTicks = false
end

-- vars
local mainMenuX = SCREEN_CENTER_X-200
local mainMenuY = SCREEN_CENTER_Y
local menuOffsetY = 28
local menuItemZoom = 20/24
local firstPress = false

return Def.ActorFrame{
	LoadActor("JudgmentStyle");
	LoadActor("JudgmentTicks");

	Def.Actor{
		Name="InputController";
		MenuInputMessageCommand=function(self,param)
			if menuState.CurState == nil then
				-- handle main input
				if not firstPress then firstPress = true return end

				if param.Input == "Back" then -- go away!
					SCREENMAN:GetTopScreen():Cancel()
				elseif param.Input == "Start" then
					local choice = menuState.MainChoice
					menuState.CurState = mainChoices[choice]
					if menuState.CurChoice == nil then
						-- tell them to handle it.
					end
					MESSAGEMAN:Broadcast("NewState", { MenuState = menuState })
				else
					local curItem = menuState.MainChoice
					local oldItem = curItem
					if param.Input == "Up" then
						if curItem-1 < 1 then
							curItem = #mainChoices
							menuState.MainChoice = curItem
						else
							curItem = curItem - 1
							menuState.MainChoice = curItem
						end
						MESSAGEMAN:Broadcast("UpdateMainChoices",{ OldItem = oldItem, NewItem = curItem })
					elseif param.Input == "Down" then
						if curItem+1 > #mainChoices then
							curItem = 1
							menuState.MainChoice = curItem
						else
							curItem = curItem + 1
							menuState.MainChoice = curItem
						end
						MESSAGEMAN:Broadcast("UpdateMainChoices",{ OldItem = oldItem, NewItem = curItem })
					end
				end
			else
				if param.Input == "Back" then
					-- we want to handle back here in all cases.
					menuState.CurState = nil
					menuState.CurChoice = nil
					MESSAGEMAN:Broadcast("NewState",nil)
				else
					MESSAGEMAN:Broadcast("ThemeOptionsSubInput",{ Input = param.Input, MenuState = menuState })
				end
			end
		end;
		MenuUpP1MessageCommand=function(self) MESSAGEMAN:Broadcast("MenuInput", { Player = PLAYER_1, Input = "Up", }); end;
		MenuUpP2MessageCommand=function(self) MESSAGEMAN:Broadcast("MenuInput", { Player = PLAYER_2, Input = "Up", }); end;
		MenuDownP1MessageCommand=function(self) MESSAGEMAN:Broadcast("MenuInput", { Player = PLAYER_1, Input = "Down", }); end;
		MenuDownP2MessageCommand=function(self) MESSAGEMAN:Broadcast("MenuInput", { Player = PLAYER_2, Input = "Down", }); end;
		MenuLeftP1MessageCommand=function(self) MESSAGEMAN:Broadcast("MenuInput", { Player = PLAYER_1, Input = "Left", }); end;
		MenuLeftP2MessageCommand=function(self) MESSAGEMAN:Broadcast("MenuInput", { Player = PLAYER_2, Input = "Left", }); end;
		MenuRightP1MessageCommand=function(self) MESSAGEMAN:Broadcast("MenuInput", { Player = PLAYER_1, Input = "Right", }); end;
		MenuRightP2MessageCommand=function(self) MESSAGEMAN:Broadcast("MenuInput", { Player = PLAYER_2, Input = "Right", }); end;
		CodeMessageCommand=function(self,param)
			MESSAGEMAN:Broadcast("MenuInput", { Player = param.PlayerNumber, Input = param.Name })
		end;
	};

	Def.ActorFrame{
		Name="MainChoices";
		LoadFont("_francophilsans Bold 24px")..{
			Name="ChoiceJudgmentStyle";
			InitCommand=cmd(xy,mainMenuX,mainMenuY-(menuOffsetY/2);shadowlength,1;zoom,menuItemZoom);
			BeginCommand=cmd(settext,ScreenString("Judgment Style"));
			UpdateMainChoicesMessageCommand=function(self,p)
				if p.NewItem == 1 then
					self:playcommand("GainFocus")
				else
					self:playcommand("LoseFocus")
				end
			end;
			CurrentStateCommand=cmd(diffuse,color("1,0.95,0,1"));
			GainFocusCommand=cmd(diffuse,color("1,1,1,1"));
			LoseFocusCommand=cmd(stoptweening;diffuse,color("0.5,0.5,0.5,0.8"));
			NewStateMessageCommand=function(self)
				if menuState.CurState == "JudgmentStyle" then
					self:playcommand("CurrentState")
				elseif menuState.CurState == nil and menuState.MainChoice == 1 then
					self:playcommand("GainFocus")
				else
					self:playcommand("LoseFocus")
				end
			end;
		};
		LoadFont("_francophilsans Bold 24px")..{
			Name="ChoiceJudgmentTicks";
			InitCommand=cmd(xy,mainMenuX,mainMenuY+(menuOffsetY/2);shadowlength,1;zoom,menuItemZoom);
			BeginCommand=function(self)
				self:settext(ScreenString("Judgment Ticks"))
				self:playcommand("LoseFocus")
			end;
			UpdateMainChoicesMessageCommand=function(self,p)
				if p.NewItem == 2 then
					self:playcommand("GainFocus")
				else
					self:playcommand("LoseFocus")
				end
			end;
			CurrentStateCommand=cmd(diffuse,color("1,0.95,0,1"));
			GainFocusCommand=cmd(diffuse,color("1,1,1,1"));
			LoseFocusCommand=cmd(stoptweening;diffuse,color("0.5,0.5,0.5,0.8"));
			NewStateMessageCommand=function(self)
				if menuState.CurState == "JudgmentTicks" then
					self:playcommand("CurrentState")
				elseif menuState.CurState == nil and menuState.MainChoice == 2 then
					self:playcommand("GainFocus")
				else
					self:playcommand("LoseFocus")
				end
			end;
		};
	};
};